/*-------------------------------------------------------*
*  Name:      Z3DUtils plug-in for ZModeler v1.05        *
*  Purpose:   3D Utils and interface stuff for ZModeler  *
*  Authors:   Oleg M.                                    *
*                                                        *
*  History:   (c) 2000-2001                              *
*                                                        *
*-------------------------------------------------------*/

#include <Struct.h>
#include <3dengine.h>
#include "CPathDlg.h"
#include "resource.h"

#include "Settings\pagecol.h"
#include "Settings\pagehighlight.h"
#include "Settings\pageopensave.h"
#include "Settings\paged3d.h"



DWORD CALLBACK Capabilities(long)
{
  return ZMODELER_BUILD_VERSION();
}


DWORD CALLBACK Supports(long)
{
  return Z3D_PLUGSUPPORTS_PROCESSING;
}

DWORD CALLBACK DynamicLoading(long)
{
  return 0L;//non dynamic
}


char* CALLBACK GetProcName(DWORD num)
{
  if (num==0) return "Search Paths...";
  if (num==1) return "Reload All Textures";
//settings:
  if (num==2) return "ZBuffer";
  if (num==3) return "Dithering";
  if (num==4) return "Specular Highlight";
  if (num==5) return "Use Fog";
  if (num==6) return "Per-face rendering";

//popup menu
  //textures:
  if (num==7) return "Use Textures";
  if (num==8) return "Smooth Textures";
  if (num==9) return "Multiple Textures (Chrome)";
  if (num==10) return "Always High Blend (High Chrome)";
  //shade, fill
  if (num==11) return "Solid";
  if (num==12) return "Flat Shading";
  //shade, fill/wireframe:
  if (num==13) return "Enabled";
  if (num==14) return "One Color";
  if (num==15) return "Color...@1";
  if (num==16) return "Shaded";
  if (num==17) return "Textured";
  //camera:
  if (num==18) return "Perspectived";
  if (num==19) return "Reset Position";
  if (num==20) return "Reset Settings";
  //Background:
  if (num==21) return "Mini grid";
  if (num==22) return "Normal grid";
  if (num==23) return "Axis";
  if (num==24) return "Custom Color";
  if (num==25) return "Color...@2";
  if (num==26) return "<separator>";
  //Background/Image
  if (num==27) return "Show Image";
  if (num==28) return "Load Image...";
  if (num==29) return "Unload Image";
  if (num==30) return "Pixels per unit";
  if (num==31) return "<separator>";
  if (num==32) return "User control";
  if (num==33) return "<separator>";
  if (num==34) return "Rotateable";
  if (num==35) return "Environment";
  if (num==36) return "<separator>";
  if (num==37) return "Reset Image";
  //../settings
  if (num==38) return "<separator>";
  if (num==39) return "Transparency";

  return NULL;
}

char* CALLBACK GetMenuFolder(DWORD num)
{
  if (num < 2)
    return "&View\\Textures Management\0";
  else
  if (num < 7)
    return "&Options\\3D View\0";
  else
  if (num < 11)
    return "&Settings\\Textures\0";
  else
  if (num < 13)
    return "&Settings\\Shade, Fill\0";
  else
  if (num < 18)
    return "&Settings\\Shade, Fill\\Wireframe\0";
  else
  if (num < 21)
    return "&Settings\\Camera\0";
  else
  if (num < 27)
    return "Background\0";
  else
  if (num < 38)
    return "Background\\Image\0";
  else
    return "&Settings\0";
}



DWORD CALLBACK GetProcsAmount(DWORD)
{
  return 40;
}


DWORD CALLBACK PlaceType(long num)
{
  return (num < 7) ? Z3D_PROCPLACE_MAINMENU : Z3D_PROCPLACE_POPUPMENU;
}


DWORD CALLBACK MenuItemType(DWORD num)
{
  if ((num < 2) || (num==15) || (num==19) || (num==20)
    || (num==25) || (num==28) || (num==29) || (num==30) || (num==37))
    return Z3D_PROCTYPE_SINGLECALL;
  else
    return Z3D_PROCTYPE_ONOFFCALLS;
}


extern DWORD CALLBACK ReloadAllTexturesActivate(tProcParams* params);


DWORD CALLBACK PluginSafeLoad(tProcParams* params)
{
  if (!params || !params->DllHandle || !params->AppHandle || !params->sysp)
    return 0;

  AfxSetResourceHandle(params->DllHandle);
  
  LOGPEN    lPen;
  LOGBRUSH  lBrush;
  CString folder = "Plugins settings\\z3dutils\\Settings\\Colors\\";

  //10 asserts here

  //////////////////
  // Colors
  Global.PenThinBlack->GetLogPen(&lPen);
  lPen.lopnColor  = params->pApp->GetProfileInt(folder, "Mesh: Default lines", lPen.lopnColor);
  Global.ColBlack = lPen.lopnColor;
  Global.PenThinBlack->DeleteObject();
  Global.PenThinBlack->CreatePenIndirect(&lPen);
  Global.PenThinBlue->GetLogPen(&lPen);
  lPen.lopnColor  = params->pApp->GetProfileInt(folder, "Mesh: Active lines", lPen.lopnColor);
  Global.ColBlue = lPen.lopnColor;
  Global.PenThinBlue->DeleteObject();
  Global.PenThinBlue->CreatePenIndirect(&lPen);
  Global.PenThinGreen->GetLogPen(&lPen);
  lPen.lopnColor  = params->pApp->GetProfileInt(folder, "Mesh: Normals", lPen.lopnColor);
  Global.ColGreen = lPen.lopnColor;
  Global.PenThinGreen->DeleteObject();
  Global.PenThinGreen->CreatePenIndirect(&lPen);
  Global.PenThinDarkRed->GetLogPen(&lPen);
  lPen.lopnColor  = params->pApp->GetProfileInt(folder, "Mesh: Selected lines", lPen.lopnColor);
  Global.ColDarkRed = lPen.lopnColor;
  Global.PenThinDarkRed->DeleteObject();
  Global.PenThinDarkRed->CreatePenIndirect(&lPen);
  Global.PenThinRed->GetLogPen(&lPen);
  lPen.lopnColor  = params->pApp->GetProfileInt(folder, "Mesh: Selected + Active lines", lPen.lopnColor);
  Global.ColRed = lPen.lopnColor;
  Global.PenThinRed->DeleteObject();
  Global.PenThinRed->CreatePenIndirect(&lPen);
  Global.PenThinGray->GetLogPen(&lPen);
  lPen.lopnColor  = params->pApp->GetProfileInt(folder, "Mesh: Disabled lines", lPen.lopnColor);
  Global.ColGray = lPen.lopnColor;
  Global.PenThinGray->DeleteObject();
  Global.PenThinGray->CreatePenIndirect(&lPen);
  Global.ColDots = params->pApp->GetProfileInt(folder, "Dots: Vertices and faces dots", Global.ColDots);

  Global.PenThinWhite->GetLogPen(&lPen);
  lPen.lopnColor  = params->pApp->GetProfileInt(folder, "Inactive Views border", lPen.lopnColor);
  Global.ColWhite = lPen.lopnColor;
  Global.PenThinWhite->DeleteObject();
  Global.PenThinWhite->CreatePenIndirect(&lPen);
  Global.PenThinBlueCreate->GetLogPen(&lPen);
  lPen.lopnColor  = params->pApp->GetProfileInt(folder, "Dots line", lPen.lopnColor);
  Global.PenThinBlueCreate->DeleteObject();
  Global.PenThinBlueCreate->CreatePenIndirect(&lPen);
  Global.MenuHighlightPen->GetLogPen(&lPen);
  lPen.lopnColor  = params->pApp->GetProfileInt(folder, "MenuBar: Highlight", lPen.lopnColor);
  Global.MenuHighlight = lPen.lopnColor;
  Global.MenuHighlightPen->DeleteObject();
  Global.MenuHighlightPen->CreatePenIndirect(&lPen);
  Global.MenuShadowPen->GetLogPen(&lPen);
  lPen.lopnColor  = params->pApp->GetProfileInt(folder, "MenuBar: Shadow", lPen.lopnColor);
  Global.MenuShadow = lPen.lopnColor;
  Global.MenuShadowPen->DeleteObject();
  Global.MenuShadowPen->CreatePenIndirect(&lPen);


  Global.MenuForegroundBrush->GetLogBrush(&lBrush);
  lBrush.lbColor  = params->pApp->GetProfileInt(folder, "MenuBar: Foreground", lBrush.lbColor);
  Global.MenuForegroundColor = lBrush.lbColor;
  Global.MenuForegroundBrush->DeleteObject();
  Global.MenuForegroundBrush->CreateBrushIndirect(&lBrush);
  Global.MenuActiveForegroundBrush->GetLogBrush(&lBrush);
  lBrush.lbColor  = params->pApp->GetProfileInt(folder,"MenuBar: Foreground (if active)", lBrush.lbColor);
  Global.MenuActiveForegroundColor = lBrush.lbColor;
  Global.MenuActiveForegroundBrush->DeleteObject();
  Global.MenuActiveForegroundBrush->CreateBrushIndirect(&lBrush);
  Global.BackgroundBrush->GetLogBrush(&lBrush);
  lBrush.lbColor  = params->pApp->GetProfileInt(folder,"Views: Background", lBrush.lbColor);
  Global.ViewsBackground = lBrush.lbColor;
  Global.BackgroundBrush->DeleteObject();
  Global.BackgroundBrush->CreateBrushIndirect(&lBrush);


  Global.GridNormalPen->GetLogPen(&lPen);
  lPen.lopnColor  = params->pApp->GetProfileInt(folder, "Views: Grid: Normal", lPen.lopnColor);
  Global.GridNormalColor = lPen.lopnColor;
  Global.GridNormalPen->DeleteObject();
  Global.GridNormalPen->CreatePenIndirect(&lPen);
  Global.GridTenthsPen->GetLogPen(&lPen);
  lPen.lopnColor  = params->pApp->GetProfileInt(folder, "Views: Grid: Tenths", lPen.lopnColor);
  Global.GridTenthsColor = lPen.lopnColor;
  Global.GridTenthsPen->DeleteObject();
  Global.GridTenthsPen->CreatePenIndirect(&lPen);
  Global.GridAxisPen->GetLogPen(&lPen);
  lPen.lopnColor  = params->pApp->GetProfileInt(folder, "Views: Grid: Axis", lPen.lopnColor);
  Global.GridAxisColor = lPen.lopnColor;
  Global.GridAxisPen->DeleteObject();
  Global.GridAxisPen->CreatePenIndirect(&lPen);

  Global.MenuCaptionColor  = params->pApp->GetProfileInt(folder, "MenuBar: Text: Color", Global.MenuCaptionColor);
  Global.MenuActiveColor  = params->pApp->GetProfileInt(folder, "MenuBar: Text: Color (if active)", Global.MenuActiveColor);

  Global.ViewsCaptionColor = params->pApp->GetProfileInt(folder, "Views: Caption Color (inactive)", Global.ViewsCaptionColor);
  Global.ViewsActiveCaptionColor = params->pApp->GetProfileInt(folder, "Views: Caption Color (active)", Global.ViewsActiveCaptionColor);

  LOGFONT* lpfont;
  UINT amount = 0;
  params->pApp->GetProfileBinary(folder, "MenuBar: Font (inactive)", (BYTE**)&lpfont, &amount);
  if (amount == sizeof(LOGFONT))
  {
    Global.MenuCaptionFont->DeleteObject();
    Global.MenuCaptionFont->CreateFontIndirect(lpfont);
    delete lpfont;
  }
  params->pApp->GetProfileBinary(folder, "MenuBar: Font (active)", (BYTE**)&lpfont, &amount);
  if (amount == sizeof(LOGFONT))
  {
    Global.MenuActiveCaptionFont->DeleteObject();
    Global.MenuActiveCaptionFont->CreateFontIndirect(lpfont);
    delete lpfont;
  }
  params->pApp->GetProfileBinary(folder, "Views: Title Font", (BYTE**)&lpfont, &amount);
  if (amount == sizeof(LOGFONT))
  {
    Global.ViewsCaptionFont->DeleteObject();
    Global.ViewsCaptionFont->CreateFontIndirect(lpfont);
    delete lpfont;
  }


  Global.MenuFontHeight = params->pApp->GetProfileInt(folder, "MenuBar Buttons height", 8);

  //////////////////
  // Highlightion
  folder = "Plugins settings\\z3dutils\\Settings\\Highlight\\";
  params->pD3D->ActiveHighlight = params->pApp->GetProfileInt(folder, "ActiveHighlightion", params->pD3D->ActiveHighlight);
  params->pD3D->SelectedHighlight = params->pApp->GetProfileInt(folder, "SelectedHighlightion", params->pD3D->SelectedHighlight);
  params->pD3D->SelActiveHighlight = params->pApp->GetProfileInt(folder, "SelActiveHighlightion", params->pD3D->SelActiveHighlight);
  params->pD3D->NormalsHighlight = params->pApp->GetProfileInt(folder, "NormalsHighlightion", params->pD3D->NormalsHighlight);
  params->pD3D->DotsHighlight = params->pApp->GetProfileInt(folder, "DotsHighlightion", params->pD3D->DotsHighlight);

  CurrentState.nOpenSaveFlags = params->pApp->GetProfileInt("Plugins settings\\z3dutils\\Settings\\OpenSave\\", "nOpenSaveFlags", CurrentState.nOpenSaveFlags);

  ////////////////////
  // D3D
  folder = "Plugins settings\\z3dutils\\Direct 3D Settings\\";

  params->pD3D->Fog = params->pApp->GetProfileInt(folder, "FOG", BitEnabled | 0xd0daFF);
  params->pD3D->fogdensity = params->pApp->GetProfileInt(folder, "FOGDencity", 100)/256.0f;
  params->pD3D->SemiTransparencyFactor = params->pApp->GetProfileInt(folder, "TransparencyFactor", 180)/256.0f;

  params->pD3D->LSpots[LeftSpot]    = params->pApp->GetProfileInt(folder, "LeftSpot", 0x808080);
  params->pD3D->LSpots[RightSpot]    = params->pApp->GetProfileInt(folder, "RightSpot", 0x808080);
  params->pD3D->LSpots[TopSpot]    = params->pApp->GetProfileInt(folder, "UpperSpot", 0x808080);
  params->pD3D->LSpots[BottomSpot]  = params->pApp->GetProfileInt(folder, "LowerSpot", 0x808080);

  BYTE rDM, gDM, bDM;
  DWORD defmatRGB = params->pApp->GetProfileInt(folder, "Default Material", 0xFFFFFF);
  rDM = (BYTE)((defmatRGB&0xFF0000)>>16);
  gDM = (BYTE)((defmatRGB&0xFF00)>>8);
  bDM = (BYTE)(defmatRGB&0xFF);

  if (params->pD3D->Materials.MaterialsAmount > 0)
  {
    params->pD3D->Materials.Materials[0].MatRec.ambient.r = (float)rDM/255.0f;
    params->pD3D->Materials.Materials[0].MatRec.ambient.g = (float)gDM/255.0f;
    params->pD3D->Materials.Materials[0].MatRec.ambient.b = (float)bDM/255.0f;
    params->pD3D->Materials.Materials[0].MatRec.diffuse.r = (float)rDM/255.0f;
    params->pD3D->Materials.Materials[0].MatRec.diffuse.g = (float)gDM/255.0f;
    params->pD3D->Materials.Materials[0].MatRec.diffuse.b = (float)bDM/255.0f;
    params->pD3D->Materials.Materials[0].MatRec.emissive.r = (float)rDM/1023.0f;
    params->pD3D->Materials.Materials[0].MatRec.emissive.g = (float)gDM/1023.0f;
    params->pD3D->Materials.Materials[0].MatRec.emissive.b = (float)bDM/1023.0f;
    params->pD3D->Materials.Materials[0].MatRec.specular.r = 1.0f;
    params->pD3D->Materials.Materials[0].MatRec.specular.g = 1.0f;
    params->pD3D->Materials.Materials[0].MatRec.specular.b = 1.0f;
  }
  //////////////////////////
  // open-save
  folder = "Plugins settings\\z3dutils\\Settings\\OpenSave\\";
  CurrentState.SetMode(CurrentState.GetMode() | params->pApp->GetProfileInt(folder, "PereferenceModes", 0));

//-----------------------------------------
// creating and adding pages:

  CPathsDialog* pPathsPage = new CPathsDialog();
  pPathsPage->Construct(IDD_TEXTURESPATHDIALOG);
  pPathsPage->pD3D = params->pD3D;

  CColorPage*    pColorPage = new CColorPage();
  pColorPage->Construct(IDD_COLORSPAGE);

  CHighLightPage* pHighLightPage = new CHighLightPage();
  pHighLightPage->Construct(IDD_HIGHLIGHTPAGE);
  
  COpenSavePage*  pFilePage = new COpenSavePage();
  pFilePage->Construct(IDD_OPENSAVEPAGE);

  CSettingsDialog* pD3DPage = new CSettingsDialog();
  pD3DPage->Construct(IDD_D3DPAGE);

  nSearchPathsPageIndex = params->sysp(Z3D_REQUEST_ADDSETTINGSPAGE, NULL, NULL, pPathsPage, NULL);
  params->sysp(Z3D_REQUEST_ADDSETTINGSPAGE, NULL, NULL, pColorPage, NULL);
  params->sysp(Z3D_REQUEST_ADDSETTINGSPAGE, NULL, NULL, pHighLightPage, NULL);
  params->sysp(Z3D_REQUEST_ADDSETTINGSPAGE, NULL, NULL, pFilePage, NULL);
  params->sysp(Z3D_REQUEST_ADDSETTINGSPAGE, NULL, NULL, pD3DPage, NULL);
  
  AfxSetResourceHandle(params->AppHandle);

// add textures reload tool into "device_change" list:
  params->ListSet->AddProc(
      Z3D_EVENT_DEVICECHANGED,
      "Reload All Textures",
      NULL,
      (PLUGPROCESSORPROC)ReloadAllTexturesActivate,
      NULL,
      NULL,
      params,
      params->DllHandle);
  return 0;
}


DWORD CALLBACK PluginUnload(tProcParams* params)
{
  if (!params || !params->pApp)
    return 0;
//--------------------------------
//  Colors
//--------------------------------
  CString folder = "Plugins settings\\z3dutils\\Settings\\Colors\\";
  LOGPEN    lPen;
  LOGBRUSH  lBrush;

  Global.PenThinBlack->GetLogPen(&lPen);
  params->pApp->WriteProfileInt(folder, "Mesh: Default lines", lPen.lopnColor);
  Global.PenThinBlue->GetLogPen(&lPen);
  params->pApp->WriteProfileInt(folder, "Mesh: Active lines", lPen.lopnColor);
  Global.PenThinGreen->GetLogPen(&lPen);
  params->pApp->WriteProfileInt(folder, "Mesh: Normals", lPen.lopnColor);
  Global.PenThinDarkRed->GetLogPen(&lPen);
  params->pApp->WriteProfileInt(folder, "Mesh: Selected lines", lPen.lopnColor);
  Global.PenThinRed->GetLogPen(&lPen);
  params->pApp->WriteProfileInt(folder, "Mesh: Selected + Active lines", lPen.lopnColor);
  Global.PenThinGray->GetLogPen(&lPen);
  params->pApp->WriteProfileInt(folder, "Mesh: Disabled lines", lPen.lopnColor);
  params->pApp->WriteProfileInt(folder, "Dots: Vertices and faces dots", Global.ColDots);
  Global.PenThinWhite->GetLogPen(&lPen);
  params->pApp->WriteProfileInt(folder, "Inactive Views border", lPen.lopnColor);
  Global.PenThinBlueCreate->GetLogPen(&lPen);
  params->pApp->WriteProfileInt(folder, "Dots line", lPen.lopnColor);
  Global.MenuHighlightPen->GetLogPen(&lPen);
  params->pApp->WriteProfileInt(folder, "MenuBar: Highlight", lPen.lopnColor);
  Global.MenuShadowPen->GetLogPen(&lPen);
  params->pApp->WriteProfileInt(folder, "MenuBar: Shadow", lPen.lopnColor);

  Global.MenuForegroundBrush->GetLogBrush(&lBrush);
  params->pApp->WriteProfileInt(folder, "MenuBar: Foreground", lBrush.lbColor);
  Global.MenuActiveForegroundBrush->GetLogBrush(&lBrush);
  params->pApp->WriteProfileInt(folder,"MenuBar: Foreground (if active)", lBrush.lbColor);
  Global.BackgroundBrush->GetLogBrush(&lBrush);
  params->pApp->WriteProfileInt(folder,"Views: Background", lBrush.lbColor);
  
  Global.GridNormalPen->GetLogPen(&lPen);
  params->pApp->WriteProfileInt(folder, "Views: Grid: Normal", lPen.lopnColor);
  Global.GridTenthsPen->GetLogPen(&lPen);
  params->pApp->WriteProfileInt(folder, "Views: Grid: Tenths", lPen.lopnColor);
  Global.GridAxisPen->GetLogPen(&lPen);
  params->pApp->WriteProfileInt(folder, "Views: Grid: Axis", lPen.lopnColor);

  params->pApp->WriteProfileInt(folder, "MenuBar: Text: Color", Global.MenuCaptionColor);
  params->pApp->WriteProfileInt(folder, "MenuBar: Text: Color (if active)", Global.MenuActiveColor);

  params->pApp->WriteProfileInt(folder, "Views: Caption Color (inactive)", Global.ViewsCaptionColor);
  params->pApp->WriteProfileInt(folder, "Views: Caption Color (active)", Global.ViewsActiveCaptionColor);

  LOGFONT lfont;
  Global.MenuCaptionFont->GetLogFont(&lfont);
  params->pApp->WriteProfileBinary(folder, "MenuBar: Font (inactive)", (BYTE*)&lfont, sizeof(LOGFONT));
  Global.MenuActiveCaptionFont->GetLogFont(&lfont);
  params->pApp->WriteProfileBinary(folder, "MenuBar: Font (active)", (BYTE*)&lfont, sizeof(LOGFONT));
  Global.ViewsCaptionFont->GetLogFont(&lfont);
  params->pApp->WriteProfileBinary(folder, "Views: Title Font", (BYTE*)&lfont, sizeof(LOGFONT));
  params->pApp->WriteProfileInt(folder, "MenuBar Buttons height", Global.MenuFontHeight);

//--------------------------------
//  Highlightion
//--------------------------------
  folder = "Plugins settings\\z3dutils\\Settings\\Highlight\\";
  params->pApp->WriteProfileInt(folder, "ActiveHighlightion", params->pD3D->ActiveHighlight);
  params->pApp->WriteProfileInt(folder, "SelectedHighlightion", params->pD3D->SelectedHighlight);
  params->pApp->WriteProfileInt(folder, "SelActiveHighlightion", params->pD3D->SelActiveHighlight);
  params->pApp->WriteProfileInt(folder, "NormalsHighlightion", params->pD3D->NormalsHighlight);
  params->pApp->WriteProfileInt(folder, "DotsHighlightion", params->pD3D->DotsHighlight);
//--------------------------------
//  OpenSave
//--------------------------------
  params->pApp->WriteProfileInt("Plugins settings\\z3dutils\\Settings\\OpenSave\\", "nOpenSaveFlags", CurrentState.nOpenSaveFlags);
  params->pApp->WriteProfileInt("Plugins settings\\z3dutils\\Settings\\OpenSave\\", "PereferenceModes",
      CurrentState.GetMode() & (Z3D_MODE_PROGRAMMING | Z3D_MODE_DEBUGALL));
//--------------------------------
//  D3D
//--------------------------------
  folder = "Plugins settings\\z3dutils\\Direct 3D Settings\\";

  params->pApp->WriteProfileInt(folder, "Backlight", params->pD3D->LBack);
  params->pApp->WriteProfileInt(folder, "LeftSpot", params->pD3D->LSpots[LeftSpot]);
  params->pApp->WriteProfileInt(folder, "RightSpot", params->pD3D->LSpots[RightSpot]);
  params->pApp->WriteProfileInt(folder, "UpperSpot", params->pD3D->LSpots[TopSpot]);
  params->pApp->WriteProfileInt(folder, "LowerSpot", params->pD3D->LSpots[BottomSpot]);
  params->pApp->WriteProfileInt(folder, "FOG",    params->pD3D->Fog);
  params->pApp->WriteProfileInt(folder, "FOGDencity", (long)(params->pD3D->fogdensity*256));
  params->pApp->WriteProfileInt(folder, "TransparencyFactor", (long)(params->pD3D->SemiTransparencyFactor*256));

  if (params->pD3D->Materials.MaterialsAmount > 0)
  {
    BYTE rDM, gDM, bDM;
    rDM = (BYTE)(params->pD3D->Materials.Materials[0].MatRec.ambient.r * 255);
    gDM = (BYTE)(params->pD3D->Materials.Materials[0].MatRec.ambient.g * 255);
    bDM = (BYTE)(params->pD3D->Materials.Materials[0].MatRec.ambient.b * 255);
    params->pApp->WriteProfileInt(folder, "Default Material", (rDM<<16) |(gDM<<8) |(bDM) );
  }
  return 0;
}